<div class="main-content">
    <section class="section">
        <div class="section-header">
            <h1><?= labels('providers', "Providers") ?></h1>
            <div class="section-header-breadcrumb">
                <div class="breadcrumb-item active"><a href="<?= base_url('/admin/dashboard') ?>"><i class="fas fa-home-alt text-primary"></i> <?= labels('Dashboard', 'Dashboard') ?></a></div>
                <div class="breadcrumb-item"><i class="fas fa-handshake text-warning"></i> <?= labels('providers', 'Provider') ?></a></div>
            </div>
        </div>
        <div class="container-fluid card">
            <div class="align-items-center bg-navy card-header d-flex justify-content-between">
                <div class="bg-navy">
                    <h4><?= labels('all_providers', "All Providers") ?></h4>
                </div>
                <div>
                    <a href="<?= base_url("admin/partners/add_partner"); ?>" class="btn btn-primary"><i class="fa fa-user-plus"></i> <?= labels('providers', 'Add Provider') ?></a>
                </div>
            </div>
            <div class="row mb-3">
                <div class="col-lg">
                    <table class="table table-striped" id="partner_list" data-detail-formatter="user_formater" data-auto-refresh="true" data-toggle="table" 
                    data-url="<?= base_url("admin/partners/list") ?>" data-side-pagination="server" data-pagination="true" data-page-list="[5, 10, 25, 50, 100, 200, All]" 
                    data-search="true" data-show-columns="true" data-show-columns-search="true" data-show-refresh="true" data-sort-name="id" data-sort-order="desc">
                        <thead>
                            <tr>
                                <th data-field="id" data-visible="false" class="text-center" data-sortable="true"><?= labels('id', 'ID') ?></th>
                                <th data-field="partner_id" class="text-center" data-visible="false" data-sortable="false"><?= labels('provider_id', 'Provider Id') ?></th>
                                <th data-field="partner_profile" class="text-center"><?= labels('profile', 'Provider Profile') ?></th>
                                <th data-field="partner_name" class="text-center" data-visible="false" data-sortable="true"><?= labels('provider_name', 'Provider Name') ?></th>
                                <th data-field="company_name" class="text-center" data-sortable="true" data-sortable="true"><?= labels('company_name', 'Company Name') ?></th>
                                <th data-field="mobile" class="text-center"><?= labels('mobile', 'Mobile') ?></th>
                                <th data-field="national_id" class="text-center" data-visible="false" data-sortable="true"><?= labels('national_id', 'National Id') ?></th>
                                <th data-field="balance" class="text-center" data-visible="false" data-sortable="true"><?= labels('balance', 'Balance') ?></th>
                                <th data-field="address_id" class="text-center" data-visible="false" data-sortable="true"><?= labels('address_id', 'Address Id') ?></th>
                                <th data-field="address" class="text-center" data-visible="false" data-sortable="false"><?= labels('address', 'Address') ?></th>
                                <th data-field="passport" class="text-center" data-visible="false" data-sortable="false"><?= labels('passport', 'Passport') ?></th>
                                <th data-field="tax_name" class="text-center" data-visible="false" data-sortable="false"><?= labels('tax_name', 'Tax Name') ?></th>
                                <th data-field="tax_number" class="text-center" data-visible="false" data-sortable="false"><?= labels('tax_number', 'Tax Number') ?></th>
                                <th data-field="bank_name" class="text-center" data-sortable="false" data-visible="false"><?= labels('bank_name', 'Bank Name') ?></th>
                                <th data-field="account_number" class="text-center" data-sortable="false" data-visible="false"><?= labels('account_number', 'Account Number') ?></th>
                                <th data-field="account_name" class="text-center" data-sortable="false" data-visible="false"><?= labels('account_name', 'Account Name') ?></th>
                                <th data-field="bank_code" class="text-center" data-sortable="false" data-visible="false"><?= labels('bank_code', 'Bank Code') ?></th>
                                <!--  -->
                                <th data-field="stars" class="text-center" data-sortable="false" data-visible="true"><?= labels('stars', 'Stars') ?></th>
                                <!--  -->
                                <th data-field="swift_code" class="text-center" data-visible="false" data-sortable="false"><?= labels('swift_code', 'Swift Code') ?></th>
                                <th data-field="advance_booking_details" class="text-center" data-visible="false" data-sortable="false"><?= labels('advance_booking_details', 'Advance Booking Details') ?></th>
                                <th data-field="type" class="text-center" data-sortable="true"><?= labels('type', 'Type') ?></th>
                                <th data-field="number_of_members" class="text-center" data-sortable="false" data-visible="false"><?= labels('number_Of_members', 'Number Of Members') ?></th>
                                <th data-field="admin_commissions" class="text-center" data-visible="false" data-sortable="false"><?= labels('admin_commissions', 'Admin Commision') ?></th>
                                <th data-field="ratings" class="text-center" data-visible="false" data-sortable="false"><?= labels('rating', 'Rating') ?></th>
                                <th data-field="number_of_ratings" class="text-center" data-sortable="true" data-visible="false"><?= labels('number_Of_rating', 'Number Of Rating') ?></th>
                                <th data-field="status" class="text-center" data-sortable="false"><?= labels('status', 'Status') ?></th>
                                <th data-field="created_at" class="text-center" data-sortable="false"><?= labels('created_at', 'Created At') ?></th>
                                <th data-field="is_approved" class="text-center" data-sortable="false" data-events="partner_events"><?= labels('is_Approved', 'Is Approved') ?></th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </div>
    </section>
</div>

<!-- model for view rating -->

<div class="modal fade" id="view_rating_model" tabindex="-1" role="dialog" aria-labelledby="view_rating_model" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLongTitle"><?= labels('provider_ratings', 'Provider Ratings') ?></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>

            <div class="modal-body">
                <div class="row ">
                    <div class="col-md">
                        <div class="table-responsive mb-3">
                            <table class="table table-striped" id="rating_table" data-detail-view="true" data-detail-formatter="user_formater" data-auto-refresh="true" data-toggle="table" data-url="" data-side-pagination="server" data-pagination="true" data-page-list="[5, 10, 25, 50, 100, 200, All]" data-search="true" data-show-columns="true" data-show-columns-search="true" data-show-refresh="true" data-sort-name="id" data-sort-order="desc">
                                <thead>
                                    <tr>
                                        <th data-field="id"><?= labels('id', 'ID') ?></th>
                                        <th data-field="user_name"><?= labels('user_name', 'USer Name') ?></th>
                                        <th data-field="service_id"><?= labels('service_id', 'Service ID') ?></th>
                                        <th data-field="stars"><?= labels('rating', 'Rating') ?></th>
                                        <th data-field="images"><?= labels('images', 'Images') ?></th>
                                        <th data-field="comment"><?= labels('comment', 'Comment') ?></th>
                                        <th data-field="created_at"><?= labels('date_of_rating', 'Date of Rating') ?></th>
                                        <!-- <th data-field="operations" data-events="rating_event"> <?= labels('operations', 'Operations') ?> </th> -->
                                    </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal"> <?= labels('close', 'Close') ?> </button>
                <button type="button" class="btn btn-primary"> <?= labels('save_changes', 'Close') ?></button>
            </div>
        </div>
    </div>
</div>


<!-- update Service -->
<div class="modal fade" id="update_modal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel"><?= labels('update_provider', 'Update Provider') ?></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <?= form_open(
                    'partner/update_partner',
                    ['method' => "post", 'class' => 'form-submit-event', 'enctype' => "multipart/form-data"]
                ); ?>
                <input type="hidden" name="partner_id" id="partner_id">
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="company"><?= labels('company_name', 'Company Name') ?></label>
                            <input id="company_name" class="form-control" type="text" name="company_name" placeholder="<?= labels('enter', 'Enter ') ?> <?= labels('company_name', 'the company name ') ?> <?= labels('here', ' Here ') ?>" required>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="type"><?= labels('type', 'Type') ?></label>
                            <select class="form-control" name="type" id="type" required>
                                <option disabled selected><?= labels('select_type', 'Select Type') ?></option>
                                <option value="0"><?= labels('individual', 'Individual') ?></option>
                                <option value="1"><?= labels('organization', 'Organization') ?></option>
                            </select>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col">
                        <div class="form-group">
                            <label for="about"><?= labels('about_provider', 'About Provider') ?></label>
                            <textarea id="about" class="form-control" type="text" name="about" rowspan="10" placeholder="<?= labels('enter', 'Enter') ?> <?= labels('about_provider', 'About Provider') ?> <?= labels('here', ' Here ') ?>"></textarea>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="visiting_charges"><?= labels('visiting_charges', 'Visiting Charges') ?></label>
                            <input id="visiting_charges" class="form-control" type="number" name="visiting_charges" placeholder="<?= labels('enter', 'Enter') ?> <?= labels('visiting_charges', 'Visiting Charges') ?> <?= labels('here', ' Here ') ?>" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="advance_booking_days"><?= labels('advance_booking_days', 'Advance Booking Days') ?></label>
                            <input id="advance_booking_days" class="form-control" type="number" name="advance_booking_days" placeholder="<?= labels('enter', 'Enter') ?> <?= labels('advance_booking_days', 'Advance Booking Days') ?> <?= labels('here', ' Here ') ?>" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="number_of_members"><?= labels('number_Of_members', 'Number of Members') ?></label>
                            <input id="number_of_members" class="form-control" type="text" name="number_of_members" placeholder="<?= labels('enter', 'Enter') ?> <?= labels('number_Of_members', 'Number of Members') ?> <?= labels('here', ' Here ') ?>" required>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label><?= labels('status', 'Status') ?><span class="text-danger text-sm">*</span></label>
                            <br>
                            <div id="is_approved" class="btn-group " style="margin-left: -11px;">
                                <label class="btn btn-primary" data-toggle-class="btn-primary" data-toggle-passive-class="btn-default">
                                    <input type="radio" name="is_approved" value="1" id="is_approved_partner"><?= labels('approved', 'Approved') ?>
                                </label>
                                <label class="btn btn-danger" data-toggle-class="btn-danger" data-toggle-passive-class="btn-default">
                                    <input type="radio" name="is_approved" value="0" id="is_disapproved_partner"> <?= labels('not_approved', 'Not approved') ?>
                                </label>
                            </div>
                        </div>
                    </div>




                </div>


                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="name"><?= labels('image', 'Image') ?> </label><br>
                            <div class="file-upload">
                                <div class="file-select">
                                    <div class="file-select-button" id="fileName"><?= labels('choose_file', 'Choose File') ?></div>
                                    <div class="file-select-name" id="noFile"><?= labels('no_file_chosen', 'No file chosen...') ?></div>
                                    <input type="file" name="image" id="image" accept="image/*" onchange="loadFileImage(event)">
                                </div>
                            </div>
                            <img src="" alt="no image found" width="130px" style="border: solid 1; border-radius: 12px;" height="100px" class="mt-2" id="image_preview">
                        </div>
                    </div>


                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="banner_image"><?= labels('banner_image', 'Banner Image') ?></label><br>
                            <div class="file-upload">
                                <div class="file-select">
                                    <div class="file-select-button" id="fileName2"><?= labels('choose_file', 'Choose File') ?></div>
                                    <div class="file-select-name" id="noFile2"><?= labels('no_file_chosen', 'No file chosen...') ?></div>
                                    <input type="file" name="banner_image" id="banner_image" accept="image/*" onchange="loadFileBannerImage(event)">
                                </div>
                            </div>
                            <img src="" alt="no image found" width="130px" style="border: solid 1; border-radius: 12px;" height="100px" class="mt-2" id="banner_image_preview">
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6">
                        <div id="map_wrapper_div_partner">
                            <div id="partner_map">
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="col-12">
                            <div class="form-group">
                                <label for="partner_location"><?= labels('current_location', 'Current Location') ?></label>
                                <input id="partner_location" class="form-control" type="text" name="partner_location">
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="form-group">
                                <div class="cities" id="cities_select">
                                    <label for="city"><?= labels('city', 'City') ?></label>
                                    <input type="text" name="city" id="city" class="form-control" placeholder="<?= labels('enter_your_providers_city_name', 'Enter your provider\'s city name') ?>" required>
                                </div>
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="form-group">
                                <label for="partner_latitude"><?= labels('latitude', 'Latitude') ?></label>
                                <input id="partner_latitude" class="form-control" type="text" name="partner_latitude" placeholder="<?= labels('latitude', 'Latitude') ?>" required>
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="form-group">
                                <label for="partner_longitude"><?= labels('longitude', 'Longitude') ?></label>
                                <input id="partner_longitude" class="form-control" type="text" name="partner_longitude" placeholder="<?= labels('longitude', 'Longitude') ?>" required>
                            </div>
                        </div>

                        <div class="col-12">
                            <div class="form-group">
                                <label for="address"><?= labels('address', 'Address') ?></label>
                                <textarea id="address" class="form-control" name="address" placeholder="<?= labels('enter', 'Enter') ?> <?= labels('address', 'Address') ?> <?= labels('here', ' Here ') ?>" required></textarea>
                            </div>
                        </div>
                    </div>

                </div>

                <div class="row">
                    <div class="col-md-8">
                        <div class="form-group">
                            <h2 class='section-title'><?= labels('working_days', 'Working Days') ?></h2>

                            <div class="row mb-3">
                                <div class="col-md-2">
                                    <label for="0"><?= labels('monday', 'Monday') ?></label>
                                </div>
                                <div class="col-md-3">
                                    <input type="time" required id="monday_opening_time" class="form-control start_time" name="start_time[]" value="
                                    <?php
                                    (isset($partner_timings[0]['opening_time']) ? $partner_timings[0]['opening_time'] : '0') ?>">
                                </div>
                                <div class="col-md-1 text-center mt-2">
                                    <?= labels('to', 'To') ?>
                                </div>
                                <div class="col-md-3 endTime">
                                    <input type="time" id="monday_closing_time" required class="form-control end_time" name="end_time[]" value="
                                    <?php
                                    (isset($partner_timings[0]['closing_time']) ? $partner_timings[0]['closing_time'] : '0') ?>">
                                </div>
                                <div class="col-md-2">
                                    <div class="form-check mt-2">
                                        <?php if (isset($partner_timings) && !empty($partner_timings) && $partner_timings[0]['is_open'] == 1) : ?>
                                            <input class="check_box check_box" type="checkbox" name="monday" id="monday" checked>
                                        <?php else : ?>
                                            <input class="check_box check_box" type="checkbox" name="monday" id="monday">
                                        <?php endif; ?>
                                        <label class="form-check-label" for="flexCheckDefault">
                                            <?= labels('open', 'Open') ?>
                                        </label>
                                    </div>
                                </div>
                            </div>
                            <div class="row mb-3">
                                <div class="col-md-2">
                                    <label for="1"> <?= labels('tuesday', 'Tuesday') ?></label>
                                </div>
                                <div class="col-md-3">
                                    <input type="time" id="tuesday_opening_time" class="form-control start_time" name="start_time[]" value="
                                    <?php
                                    (isset($partner_timings[1]['opening_time']) ? $partner_timings[1]['opening_time'] : '0') ?>">
                                </div>
                                <div class="col-md-1 text-center mt-2">
                                    <?= labels('to', 'To') ?>
                                </div>
                                <div class="col-md-3 endTime">
                                    <input type="time" id="tuesday_closing_time" class="form-control end_time" name="end_time[]" value="
                                    <?php (isset($partner_timings[1]['closing_time']) ? $partner_timings[1]['closing_time'] : '0') ?>">
                                </div>
                                <div class="col-md-2">
                                    <div class="form-check mt-2">
                                        <?php if (!empty($partner_timings) && $partner_timings[1]['is_open'] == 1) : ?>
                                            <input class="check_box check_box" type="checkbox" name="tuesday" id="tuesday" checked>
                                        <?php else : ?>
                                            <input class="check_box check_box" type="checkbox" name="tuesday" id="tuesday">
                                        <?php endif; ?>
                                        <label class="form-check-label" for="flexCheckDefault">
                                            <?= labels('open', 'Open') ?>
                                        </label>
                                    </div>
                                </div>
                            </div>
                            <div class="row mb-3">
                                <div class="col-md-2">
                                    <label for="2"> <?= labels('wednesday', 'Wednesday') ?></label>
                                </div>
                                <div class="col-md-3">
                                    <input type="time" id="wednesday_opening_time" class="form-control start_time" name="start_time[]" value="
                                    <?php
                                    (isset($partner_timings[2]['opening_time']) ? $partner_timings[2]['opening_time'] : '0') ?> ">
                                </div>
                                <div class="col-md-1  text-center mt-2">
                                    <?= labels('to', 'To') ?>
                                </div>
                                <div class="col-md-3 endTime">
                                    <input type="time" id="wednesday_closing_time" class="form-control end_time" name="end_time[]" value="
                                    <?php (isset($partner_timings[2]['closing_time']) ? $partner_timings[2]['closing_time'] : '0') ?>">
                                </div>
                                <div class="col-md-2">
                                    <div class="form-check mt-2">
                                        <?php if (!empty($partner_timings) && $partner_timings[2]['is_open'] == 1) : ?>
                                            <input class="check_box check_box" type="checkbox" name="wednesday" id="wednesday">
                                        <?php else : ?>
                                            <input class="check_box check_box" type="checkbox" name="wednesday" id="wednesday">
                                        <?php endif; ?>
                                        <label class="form-check-label" for="flexCheckDefault">
                                            <?= labels('open', 'Open') ?>
                                        </label>
                                    </div>
                                </div>
                            </div>
                            <div class="row mb-3">
                                <div class="col-md-2">
                                    <label for="3"> <?= labels('thursday', 'Thursday') ?></label>
                                </div>
                                <div class="col-md-3">
                                    <input type="time" id="thursday_opening_time" class="form-control start_time" name="start_time[]" value="
                                     <?php
                                        (isset($partner_timings[3]['opening_time']) ? $partner_timings[3]['opening_time'] : '0') ?>">
                                </div>
                                <div class="col-md-1 text-center mt-2">
                                    <?= labels('to', 'To') ?>
                                </div>
                                <div class="col-md-3 endTime">
                                    <input type="time" id="thursday_closing_time" class="form-control end_time" name="end_time[]" value="
                                    <?php (isset($partner_timings[3]['closing_time']) ? $partner_timings[3]['closing_time'] : '0') ?>">
                                </div>
                                <div class="col-md-2">
                                    <div class="form-check mt-2">
                                        <?php if (!empty($partner_timings) && $partner_timings[1]['is_open'] == 1) : ?>
                                            <input class="check_box check_box" type="checkbox" name="thursday" id="thursday" checked>
                                        <?php else : ?>
                                            <input class="check_box check_box" type="checkbox" name="thursday" id="thursday">
                                        <?php endif; ?>
                                        <label class="form-check-label" for="flexCheckDefault">
                                            <?= labels('open', 'Open') ?>
                                        </label>
                                    </div>
                                </div>
                            </div>
                            <div class="row mb-3">
                                <div class="col-md-2">
                                    <label for="4"> <?= labels('friday', 'Friday') ?></label>
                                </div>
                                <div class="col-md-3">
                                    <input type="time" id="friday_opening_time" class="form-control start_time" name="start_time[]" value="
                                     <?php
                                        (isset($partner_timings[4]['opening_time']) ? $partner_timings[4]['opening_time'] : '0') ?>">
                                </div>
                                <div class="col-md-1 text-center mt-2">
                                    <?= labels('to', 'To') ?>
                                </div>
                                <div class="col-md-3 endTime">
                                    <input type="time" id="friday_closing_time" class="form-control end_time" name="end_time[]" value="
                                    <?php (isset($partner_timings[4]['closing_time']) ? $partner_timings[4]['closing_time'] : '0') ?>">
                                </div>
                                <div class="col-md-2">
                                    <div class="form-check mt-2">
                                        <?php if (!empty($partner_timings) && $partner_timings[1]['is_open'] == 1) : ?>
                                            <input class="check_box check_box" type="checkbox" name="friday" id="friday" checked>
                                        <?php else : ?>
                                            <input class="check_box check_box" type="checkbox" name="friday" id="friday">
                                        <?php endif; ?>
                                        <label class="form-check-label" for="flexCheckDefault">
                                            <?= labels('open', 'Open') ?>
                                        </label>
                                    </div>
                                </div>
                            </div>
                            <div class="row mb-3">
                                <div class="col-md-2">
                                    <label for="5"> <?= labels('saturday', 'Saturday') ?></label>
                                </div>
                                <div class="col-md-3">
                                    <input type="time" id="saturday_opening_time" class="form-control start_time" name="start_time[]" value="
                                     <?php
                                        (isset($partner_timings[5]['opening_time']) ? $partner_timings[5]['opening_time'] : '0') ?>">
                                </div>
                                <div class="col-md-1 text-center mt-2">
                                    <?= labels('to', 'To') ?>
                                </div>
                                <div class="col-md-3 endTime">
                                    <input type="time" id="saturday_closing_time" class="form-control end_time" name="end_time[]" value="
                                    <?php (isset($partner_timings[5]['closing_time']) ? $partner_timings[5]['closing_time'] : '0') ?>">
                                </div>
                                <div class="col-md-2">
                                    <div class="form-check mt-2">
                                        <?php if (!empty($partner_timings) && $partner_timings[1]['is_open'] == 1) : ?>
                                            <input class="check_box check_box" type="checkbox" name="saturday" id="saturday" checked>
                                        <?php else : ?>
                                            <input class="check_box check_box" type="checkbox" name="saturday" id="saturday">
                                        <?php endif; ?>
                                        <label class="form-check-label" for="flexCheckDefault">
                                            <?= labels('open', 'Open') ?>
                                        </label>
                                    </div>
                                </div>
                            </div>
                            <div class="row mb-3">
                                <div class="col-md-2">
                                    <label for="6"> <?= labels('sunday', 'Sunday') ?></label>
                                </div>
                                <div class="col-md-3">
                                    <input type="time" id="sunday_opening_time" class="form-control start_time" name="start_time[]" value="
                                     <?php
                                        (isset($partner_timings[6]['opening_time']) ? $partner_timings[6]['opening_time'] : '0') ?>">
                                </div>
                                <div class="col-md-1 text-center mt-2">
                                    <?= labels('to', 'To') ?>
                                </div>
                                <div class="col-md-3 endTime">
                                    <input type="time" id="sunday_closing_time" class="form-control end_time" name="end_time[]" value="
                                    <?php (isset($partner_timings[6]['closing_time']) ? $partner_timings[6]['closing_time'] : '0') ?>">
                                </div>
                                <div class="col-md-2">
                                    <div class="form-check mt-2">
                                        <?php if (!empty($partner_timings) && $partner_timings[1]['is_open'] == 1) : ?>
                                            <input class="check_box check_box" type="checkbox" name="sunday" id="sunday" checked>
                                        <?php else : ?>
                                            <input class="check_box check_box" type="checkbox" name="sunday" id="sunday">
                                        <?php endif; ?>
                                        <label class="form-check-label" for="flexCheckDefault">
                                            <?= labels('open', 'Open') ?>
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-12">


                        <h2 class='section-title'> <?= labels('personal_details', 'Personal Details') ?></h2>


                        <div class="row">
                            <div class="col-4">
                                <div class="form-group">
                                    <label for="name"><?= labels('name', 'Name') ?></label>
                                    <input id="username" class="form-control" type="text" name="username" placeholder="<?= labels('enter', 'Enter') ?> <?= labels('name', 'Name') ?> <?= labels('here', ' Here ') ?>" required>
                                </div>
                            </div>
                            <div class="col-4">
                                <div class="form-group">
                                    <label for="email"><?= labels('email', 'Email') ?></label>
                                    <input id="email" class="form-control" type="text" name="email" placeholder="<?= labels('enter', 'Enter') ?> <?= labels('email', 'Email') ?> <?= labels('here', ' Here ') ?>" required>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="phone"><?= labels('phone_number', 'Phone Number') ?></label>
                                    <input id="phone" class="form-control" type="number" name="phone" placeholder="<?= labels('enter', 'Enter') ?> <?= labels('phone_number', 'Phone Number') ?> <?= labels('here', ' Here ') ?>" required>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                           
                            <div class="col-md-8">
                                <div class="form-group">
                                    <label for="admin_commission"><?= labels('commision', 'Commision') ?>(%)<small>( <?= labels('commision', 'Commision') ?>(%)<?= labels('commision_note', 'to be given to the Super Admin on Service') ?>)</small></label>
                                    <input id="admin_commission" class="form-control" type="number" name="admin_commission" placeholder="<?= labels('enter', 'Enter') ?> <?= labels('commision', 'Commision') ?> <?= labels('here', ' Here ') ?>" min="0">
                                </div>
                            </div>

                        </div>
                        <div class="row">

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="passport"><?= labels('passport', 'Passport') ?></label><br>
                                    <div class="file-upload">
                                        <div class="file-select">
                                            <div class="file-select-button" id="fileName3"><?= labels('choose_file', 'Choose File') ?></div>
                                            <div class="file-select-name" id="noFile3"><?= labels('no_file_chosen', 'No file chosen...') ?>.</div>
                                            <input type="file" name="passport" id="passport" accept="image/*" onchange="loadFilePassoport(event)">
                                        </div>
                                    </div>
                                    <img src="" alt="no image found" width="130px" height="100px" style="border: solid 1; border-radius: 12px;" class="mt-2" id="passport_preview">
                                </div>
                            </div>


                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="national_id"><?= labels('national_identity', 'National Identity') ?></label><br>
                                    <div class="file-upload">
                                        <div class="file-select">
                                            <div class="file-select-button" id="fileName4"><?= labels('choose_file', 'Choose File') ?></div>
                                            <div class="file-select-name" id="noFile4"><?= labels('no_file_chosen', 'No file chosen...') ?></div>
                                            <input type="file" name="national_id" id="national_id" accept="image/*" onchange="loadFileNationalID(event)">
                                        </div>
                                    </div>
                                    <img src="" alt="no image found" width="130px" height="100px" style="border: solid 1; border-radius: 12px;" class="mt-2" id="national_id_preview">
                                </div>
                            </div>


                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="national_id"><?= labels('address_id', 'Address Identity') ?></label><br>
                                    <div class="file-upload">
                                        <div class="file-select">
                                            <div class="file-select-button" id="fileName5"><?= labels('choose_file', 'Choose File') ?></div>
                                            <div class="file-select-name" id="noFile5"><?= labels('no_file_chosen', 'No file chosen...') ?></div>
                                            <input type="file" name="address_id" id="address_id" accept="image/*" onchange="loadFileAddressId(event)">
                                        </div>
                                    </div>
                                    <img src="" alt="no image found" width="130px" height="100px" style="border: solid 1; border-radius: 12px;" class="mt-2" id="address_id_preview">
                                </div>
                            </div>

                        </div>



                    </div>
                    <div class="col-md-12">

                        <h2 class='section-title'><?= labels('bank_details', 'Bank Details') ?></h2>


                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="tax_name"><?= labels('tax_name', 'Tax Name') ?></label>
                                    <input id="tax_name" class="form-control" type="text" name="tax_name" placeholder="<?= labels('enter', 'Enter') ?> <?= labels('tax_name', 'Tax Name') ?> <?= labels('here', ' Here ') ?>" required>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="tax_number"><?= labels('tax_number', 'Tax Number') ?></label>
                                    <input id="tax_number" class="form-control" type="text" name="tax_number" placeholder="<?= labels('enter', 'Enter') ?> <?= labels('tax_number', 'Tax Number') ?> <?= labels('here', ' Here ') ?>" required>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="account_number"><?= labels('account_number', 'Account Number') ?></label>
                                    <input id="account_number" class="form-control" type="text" name="account_number" placeholder="<?= labels('enter', 'Enter') ?> <?= labels('account_number', 'Account Number') ?> <?= labels('here', ' Here ') ?>" required>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="account_name"><?= labels('account_name', 'Account Name') ?></label>
                                    <input id="account_name" class="form-control" type="text" name="account_name" placeholder="<?= labels('enter', 'Enter') ?> <?= labels('account_name', 'Account Name') ?> <?= labels('here', ' Here ') ?>" required>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="bank_code"><?= labels('bank_code', 'Bank Code') ?></label>
                                    <input id="bank_code" class="form-control" type="text" name="bank_code" placeholder="<?= labels('enter', 'Enter') ?> <?= labels('bank_code', 'Bank Code') ?> <?= labels('here', ' Here ') ?>" required>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="bank_name"><?= labels('bank_name', 'Bank Name') ?></label>
                                    <input id="bank_name" class="form-control" type="text" name="bank_name" placeholder="<?= labels('enter', 'Enter') ?> <?= labels('bank_name', 'Bank Name') ?> <?= labels('here', ' Here ') ?>" required>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="swift_code"><?= labels('swift_code', 'Swift Code') ?></label>
                                    <input id="swift_code" class="form-control" type="text" name="swift_code" placeholder="<?= labels('enter', 'Enter') ?> <?= labels('swift_code', 'Swift Code') ?> <?= labels('here', ' Here ') ?>" required>
                                </div>
                            </div>
                        </div>


                    </div>

                </div>


                <div class="row">
                    <div class="col-md-2">
                        <div class="form-group">
                            <input type="submit" value="<?= labels('update_provider', 'Update Provider') ?>" id="service_submit" class="btn btn-success btn-block">
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <input type="button" onclick="test()" value="<?= labels('Reset', 'Reset') ?>" class="btn btn-danger btn-block">
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <button type="button" class="btn btn-secondary btn-block" data-dismiss="modal"><?= labels('close', 'Close') ?></button>
                        </div>
                    </div>
                </div>
                <?= form_close() ?>
            </div>
        </div>
    </div>
</div>
<script>
    $('#image').bind('change', function() {
        var filename = $("#image").val();
        console.log(filename);
        if (/^\s*$/.test(filename)) {
            $(".file-upload").removeClass('active');
            $("#noFile").text("No file chosen...");
        } else {
            $(".file-upload").addClass('active');
            $("#noFile").text(filename.replace("C:\\fakepath\\", ""));
        }
    });
    $('#banner_image').bind('change', function() {
        var filename = $("#banner_image").val();
        if (/^\s*$/.test(filename)) {
            $(".file-upload").removeClass('active');
            $("#noFile2").text("No file chosen...");
        } else {
            $(".file-upload").addClass('active');
            $("#noFile2").text(filename.replace("C:\\fakepath\\", ""));
        }
    });
    $('#passport').bind('change', function() {
        var filename = $("#passport").val();
        if (/^\s*$/.test(filename)) {
            $(".file-upload").removeClass('active');
            $("#noFile3").text("No file chosen...");
        } else {
            $(".file-upload").addClass('active');
            $("#noFile3").text(filename.replace("C:\\fakepath\\", ""));
        }
    });
    $('#national_id').bind('change', function() {
        var filename = $("#national_id").val();
        if (/^\s*$/.test(filename)) {
            $(".file-upload").removeClass('active');
            $("#noFile4").text("No file chosen...");
        } else {
            $(".file-upload").addClass('active');
            $("#noFile4").text(filename.replace("C:\\fakepath\\", ""));
        }
    });
    $('#address_id').bind('change', function() {
        var filename = $("#address_id").val();
        if (/^\s*$/.test(filename)) {
            $(".file-upload").removeClass('active');
            $("#noFile5").text("No file chosen...");
        } else {
            $(".file-upload").addClass('active');
            $("#noFile5").text(filename.replace("C:\\fakepath\\", ""));
        }
    });



    $('#image').bind('change', function() {
        var filename = $("#image").val();
        console.log(filename);
        if (/^\s*$/.test(filename)) {
            $(".file-upload").removeClass('active');
            $("#noFile").text("No file chosen...");
        } else {
            $(".file-upload").addClass('active');
            $("#noFile").text(filename.replace("C:\\fakepath\\", ""));
        }
    });

    function loadFileImage(event) {
        var image = document.getElementById('image_preview');
        image.src = URL.createObjectURL(event.target.files[0]);
    };


    function loadFileBannerImage(event) {
        var image = document.getElementById('banner_image_preview');
        image.src = URL.createObjectURL(event.target.files[0]);
    };

    function loadFileNationalID(event) {
        var image = document.getElementById('national_id_preview');
        image.src = URL.createObjectURL(event.target.files[0]);
    }


    function loadFilePassoport(event) {
        var image = document.getElementById('passport_preview');
        image.src = URL.createObjectURL(event.target.files[0]);
    }

    function loadFileAddressId(event) {
        var image = document.getElementById('address_id_preview');
        image.src = URL.createObjectURL(event.target.files[0]);
    }
</script>